package gov.va.med.mhv.rxrefill.data.model;

import java.io.Serializable;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToOne;
import javax.persistence.Table;

import gov.va.med.mhv.common.data.model.PatientRegistryChange;

@Entity
@Table(name = "PHARM_PATIENT_CHANGE")
public class PharmPatientChange implements Serializable {
	private static final long serialVersionUID = -5775746211908548506L;

	@Id
	@Column(name = "PHARM_PATIENT_CHANGE")
	@GeneratedValue(strategy = GenerationType.AUTO)
	private Long id;
	
	@Column(name = "OPLOCK")
	private Integer oplock = 1;
	
	@Column(name = "PHARM_PATIENT_ID", insertable = false, updatable = false)
	private Long pharmPatientId;

	@ManyToOne(fetch = FetchType.EAGER)
	@JoinColumn(name = "PHARM_PATIENT_ID")
	private PharmacyPatient parentPharmacyPatient;
	
	@Column(name = "PATIENT_REG_CHANGE_ID", insertable = false, updatable = false)
	private Long patientRegistryChangeId;

	@OneToOne(fetch = FetchType.EAGER)
	@JoinColumn(name = "PATIENT_REG_CHANGE_ID")
	private PatientRegistryChange patientRegistryChange;

	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public Integer getOplock() {
		return oplock;
	}

	public void setOplock(Integer oplock) {
		this.oplock = oplock;
	}

	public Long getPharmPatientId() {
		return pharmPatientId;
	}

	public void setPharmPatientId(Long pharmPatientId) {
		this.pharmPatientId = pharmPatientId;
	}

	public PharmacyPatient getParentPharmacyPatient() {
		return parentPharmacyPatient;
	}

	public void setParentPharmacyPatient(PharmacyPatient parentPharmacyPatient) {
		this.parentPharmacyPatient = parentPharmacyPatient;
	}

	public Long getPatientRegistryChangeId() {
		return patientRegistryChangeId;
	}

	public void setPatientRegistryChangeId(Long patientRegistryChangeId) {
		this.patientRegistryChangeId = patientRegistryChangeId;
	}

	public PatientRegistryChange getPatientRegistryChange() {
		return patientRegistryChange;
	}

	public void setPatientRegistryChange(PatientRegistryChange patientRegistryChange) {
		this.patientRegistryChange = patientRegistryChange;
	}
}
